﻿using UnityEngine;

public class SceneScript : MonoBehaviour
{
	private readonly Rect m_FirstTextAreaLocation = new Rect(Screen.width / 5, Screen.height / 2, Screen.width / 5, Screen.height / 10);
	private readonly Rect m_SecondTextAreaLocation = new Rect(3 * Screen.width / 5, Screen.height / 2, Screen.width / 5, Screen.height / 10);
	private readonly Rect m_CalculateButtonLocation = new Rect(2 * Screen.width / 5, 4 * Screen.height / 5, Screen.width / 5, Screen.height / 10);
	private readonly Rect m_ResultLabelLocation = new Rect(2 * Screen.width / 5, 3 * Screen.height / 5, Screen.width / 5, Screen.height / 10);
	private GUIStyle m_GuiStyle;

	private string m_FirstNumber, m_SecondNumber;
	private string m_Result;

	public delegate int AddFunction(int first, int second);
	private AddFunction addFunction;

	void Start()
	{
		m_GuiStyle = new GUIStyle { alignment = TextAnchor.MiddleCenter, fontSize = 32 };
	}

	void OnGUI()
	{
		m_FirstNumber = GUI.TextArea(m_FirstTextAreaLocation, m_FirstNumber ?? "");
		m_SecondNumber = GUI.TextArea(m_SecondTextAreaLocation, m_SecondNumber ?? "");

		int first, second;
		bool firstParsed = false,
			secondParsed = false;

		if (int.TryParse(m_FirstNumber, out first))
		{
			firstParsed = true;
		}

		if (int.TryParse(m_SecondNumber, out second))
		{
			secondParsed = true;
		}

		if (firstParsed && secondParsed)
		{
			if (GUI.Button(m_CalculateButtonLocation, "Calculate"))
			{
				if (addFunction != null)
				{
					m_Result = "Result: " + addFunction(first, second).ToString();
				}
				else
				{
					m_Result = "Add function wasn't set!";
				}
			}
		}
		
		GUI.Label(m_ResultLabelLocation, m_Result, m_GuiStyle);
	}

	public void SetAddFunction(AddFunction func)
	{
		addFunction = func;
	}
}
